/// \file
/// \ingroup tutorial_tree
/// \notebook -nodraw
/// Example of Root macro to copy a subset of a Tree to a new Tree, selecting entries.
///
/// Only selected entries are copied to the new Tree.
/// The input file has been generated by the program in `$ROOTSYS/test/Event`
/// with `Event 1000 1 99 1`
///
/// \macro_code
///
/// \author Rene Brun

R__LOAD_LIBRARY($ROOTSYS/test/libEvent.so)

void copytree3() {

   //Get old file, old tree and set top branch address
   TFile *oldfile;
   TString dir = "$ROOTSYS/test/Event.root";
   gSystem->ExpandPathName(dir);
   if (!gSystem->AccessPathName(dir))
       {oldfile = new TFile("$ROOTSYS/test/Event.root");}
   else {oldfile = new TFile("./Event.root");}
   TTree *oldtree = (TTree*)oldfile->Get("T");
   Long64_t nentries = oldtree->GetEntries();
   Event *event   = 0;
   oldtree->SetBranchAddress("event",&event);

   //Create a new file + a clone of old tree in new file
   TFile *newfile = new TFile("small.root","recreate");
   TTree *newtree = oldtree->CloneTree(0);

   for (Long64_t i=0;i<nentries; i++) {
      oldtree->GetEntry(i);
      if (event->GetNtrack() > 605) newtree->Fill();
      event->Clear();
   }
   newtree->Print();
   newtree->AutoSave();
   delete oldfile;
   delete newfile;
}
